/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.jobs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.CraftingType;

@Singleton
public class CraftingTypeDictionary {
    private Map<String, CraftingType> byName = new HashMap<String, CraftingType>();

    @Inject
    public CraftingTypeDictionary(ProfessionDictionary professionDictionary) throws IOException {
        this(new File("assets/definitions/craftingTypes.json"), professionDictionary);
    }

    public CraftingTypeDictionary(File craftingTypesJsonFile, ProfessionDictionary professionDictionary) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        List craftingTypes = (List)objectMapper.readValue(FileUtils.readFileToString(craftingTypesJsonFile, "UTF-8"), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, CraftingType.class));
        for (CraftingType craftingType : craftingTypes) {
            craftingType.setProfessionRequired(professionDictionary.getByName(craftingType.getProfessionRequiredName()));
            this.byName.put(craftingType.getName(), craftingType);
        }
    }

    public CraftingType getByName(String name) {
        return this.byName.get(name);
    }

    public Collection<CraftingType> getAll() {
        return this.byName.values();
    }
}

